/*
 * Decompiled with CFR 0.152.
 */
package eu.devunit;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import eu.devunit.TodoItem;
import eu.devunit.TodoManager;
import java.util.List;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;

public class TodoCommand {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"todo").executes(TodoCommand::listAllTodos)).then(class_2170.method_9247((String)"add").then(class_2170.method_9244((String)"task", (ArgumentType)StringArgumentType.greedyString()).executes(TodoCommand::addUnassignedTodo)))).then(class_2170.method_9247((String)"assign").then(class_2170.method_9244((String)"task", (ArgumentType)StringArgumentType.string()).then(class_2170.method_9244((String)"assignee", (ArgumentType)StringArgumentType.word()).executes(TodoCommand::addAssignedTodo))))).then(class_2170.method_9247((String)"take").then(class_2170.method_9244((String)"id", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(TodoCommand::takeTodo)))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"list").executes(TodoCommand::listAllTodos)).then(class_2170.method_9247((String)"unassigned").executes(TodoCommand::listUnassignedTodos))).then(class_2170.method_9247((String)"mine").executes(TodoCommand::listMyTodos))).then(class_2170.method_9244((String)"assignee", (ArgumentType)StringArgumentType.word()).executes(TodoCommand::listTodosByAssignee)))).then(class_2170.method_9247((String)"remove").then(class_2170.method_9244((String)"id", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(TodoCommand::removeTodo)))).then(class_2170.method_9247((String)"clear").executes(TodoCommand::clearTodos)));
    }

    private static int addUnassignedTodo(CommandContext<class_2168> context) {
        String task = StringArgumentType.getString(context, (String)"task");
        String creator = ((class_2168)context.getSource()).method_9214();
        TodoItem item = TodoManager.addUnassignedTodo(task, creator);
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("\u00a7aTodo added: " + item.toString())), false);
        return 1;
    }

    private static int addAssignedTodo(CommandContext<class_2168> context) {
        String task = StringArgumentType.getString(context, (String)"task");
        String assignee = StringArgumentType.getString(context, (String)"assignee");
        String creator = ((class_2168)context.getSource()).method_9214();
        TodoItem item = TodoManager.addTodo(task, creator, assignee);
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("\u00a7aTodo added: " + item.toString())), false);
        return 1;
    }

    private static int takeTodo(CommandContext<class_2168> context) {
        int id = IntegerArgumentType.getInteger(context, (String)"id");
        String player = ((class_2168)context.getSource()).method_9214();
        TodoItem todo = TodoManager.getTodo(id);
        if (todo == null) {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("\u00a7cTodo #" + id + " not found")), false);
            return 0;
        }
        if (!todo.isUnassigned()) {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("\u00a7cTodo #" + id + " is already assigned to " + todo.getAssignee())), false);
            return 0;
        }
        TodoManager.takeTodo(id, player);
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("\u00a7aYou took todo: " + todo.toString())), false);
        return 1;
    }

    private static int listAllTodos(CommandContext<class_2168> context) {
        List<TodoItem> todos = TodoManager.getAllTodos();
        if (todos.isEmpty()) {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"\u00a7eNo todos found"), false);
            return 0;
        }
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"\u00a76=== All Todos ==="), false);
        for (TodoItem todo : todos) {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)todo.toString()), false);
        }
        return todos.size();
    }

    private static int listUnassignedTodos(CommandContext<class_2168> context) {
        List<TodoItem> todos = TodoManager.getUnassignedTodos();
        if (todos.isEmpty()) {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"\u00a7eNo unassigned todos found"), false);
            return 0;
        }
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"\u00a76=== Unassigned Todos ==="), false);
        for (TodoItem todo : todos) {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)todo.toString()), false);
        }
        return todos.size();
    }

    private static int listMyTodos(CommandContext<class_2168> context) {
        String player = ((class_2168)context.getSource()).method_9214();
        List<TodoItem> todos = TodoManager.getTodosByAssignee(player);
        if (todos.isEmpty()) {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"\u00a7eYou have no assigned todos"), false);
            return 0;
        }
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"\u00a76=== Your Todos ==="), false);
        for (TodoItem todo : todos) {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)todo.toString()), false);
        }
        return todos.size();
    }

    private static int listTodosByAssignee(CommandContext<class_2168> context) {
        String assignee = StringArgumentType.getString(context, (String)"assignee");
        List<TodoItem> todos = TodoManager.getTodosByAssignee(assignee);
        if (todos.isEmpty()) {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("\u00a7eNo todos found for " + assignee)), false);
            return 0;
        }
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("\u00a76=== Todos for " + assignee + " ===")), false);
        for (TodoItem todo : todos) {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)todo.toString()), false);
        }
        return todos.size();
    }

    private static int removeTodo(CommandContext<class_2168> context) {
        int id = IntegerArgumentType.getInteger(context, (String)"id");
        if (TodoManager.removeTodo(id)) {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("\u00a7aTodo #" + id + " removed")), false);
            return 1;
        }
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("\u00a7cTodo #" + id + " not found")), false);
        return 0;
    }

    private static int clearTodos(CommandContext<class_2168> context) {
        TodoManager.clearAll();
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"\u00a7aAll todos cleared"), false);
        return 1;
    }
}

