/*
 * Decompiled with CFR 0.152.
 */
package eu.devunit;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

public class TodoItem {
    private static int nextId = 1;
    private final int id;
    private String task;
    private String creator;
    private String assignee;
    private LocalDateTime createdDate;

    public TodoItem(String task, String creator, String assignee) {
        this.id = nextId++;
        this.task = task;
        this.creator = creator;
        this.assignee = assignee;
        this.createdDate = LocalDateTime.now();
    }

    public TodoItem(int id, String task, String creator, String assignee, LocalDateTime createdDate) {
        this.id = id;
        this.task = task;
        this.creator = creator;
        this.assignee = assignee;
        this.createdDate = createdDate;
        if (id >= nextId) {
            nextId = id + 1;
        }
    }

    public int getId() {
        return this.id;
    }

    public String getTask() {
        return this.task;
    }

    public void setTask(String task) {
        this.task = task;
    }

    public String getCreator() {
        return this.creator;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public String getAssignee() {
        return this.assignee;
    }

    public void setAssignee(String assignee) {
        this.assignee = assignee;
    }

    public LocalDateTime getCreatedDate() {
        return this.createdDate;
    }

    public boolean isUnassigned() {
        return this.assignee == null || this.assignee.isEmpty() || this.assignee.equals("unassigned");
    }

    public String toString() {
        String assigneeStr = this.isUnassigned() ? "\u00a77Unassigned" : "\u00a7b" + this.assignee;
        return String.format("\u00a7f#%d: \u00a7e%s \u00a77| Creator: \u00a7a%s \u00a77| Assignee: %s \u00a77| Created: \u00a76%s", this.id, this.task, this.creator, assigneeStr, this.createdDate.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm")));
    }

    public static class TodoItemAdapter
    implements JsonSerializer<TodoItem>,
    JsonDeserializer<TodoItem> {
        public JsonElement serialize(TodoItem src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject obj = new JsonObject();
            obj.addProperty("id", (Number)src.id);
            obj.addProperty("task", src.task);
            obj.addProperty("creator", src.creator);
            obj.addProperty("assignee", src.assignee);
            obj.addProperty("createdDate", src.createdDate.toString());
            return obj;
        }

        public TodoItem deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject obj = json.getAsJsonObject();
            return new TodoItem(obj.get("id").getAsInt(), obj.get("task").getAsString(), obj.get("creator").getAsString(), obj.get("assignee").getAsString(), LocalDateTime.parse(obj.get("createdDate").getAsString()));
        }
    }
}

