/*
 * Decompiled with CFR 0.152.
 */
package eu.devunit;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import eu.devunit.TodoItem;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.fabricmc.loader.api.FabricLoader;

public class TodoManager {
    private static final Map<Integer, TodoItem> todos = new HashMap<Integer, TodoItem>();
    private static final Path SAVE_FILE = FabricLoader.getInstance().getConfigDir().resolve("todolist.json");
    private static final Gson gson = new GsonBuilder().registerTypeAdapter(TodoItem.class, (Object)new TodoItem.TodoItemAdapter()).setPrettyPrinting().create();

    public static void loadTodos() {
        if (!Files.exists(SAVE_FILE, new LinkOption[0])) {
            return;
        }
        try {
            String json = Files.readString(SAVE_FILE);
            Type listType = new TypeToken<List<TodoItem>>(){}.getType();
            List todoList = (List)gson.fromJson(json, listType);
            todos.clear();
            if (todoList != null) {
                for (TodoItem todo : todoList) {
                    todos.put(todo.getId(), todo);
                }
            }
        }
        catch (IOException e) {
            System.err.println("Failed to load todos: " + e.getMessage());
        }
    }

    public static void saveTodos() {
        try {
            ArrayList<TodoItem> todoList = new ArrayList<TodoItem>(todos.values());
            String json = gson.toJson(todoList);
            Files.createDirectories(SAVE_FILE.getParent(), new FileAttribute[0]);
            Files.writeString(SAVE_FILE, (CharSequence)json, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (IOException e) {
            System.err.println("Failed to save todos: " + e.getMessage());
        }
    }

    public static TodoItem addTodo(String task, String creator, String assignee) {
        TodoItem item = new TodoItem(task, creator, assignee);
        todos.put(item.getId(), item);
        TodoManager.saveTodos();
        return item;
    }

    public static TodoItem addUnassignedTodo(String task, String creator) {
        return TodoManager.addTodo(task, creator, "unassigned");
    }

    public static boolean removeTodo(int id) {
        boolean removed;
        boolean bl = removed = todos.remove(id) != null;
        if (removed) {
            TodoManager.saveTodos();
        }
        return removed;
    }

    public static TodoItem getTodo(int id) {
        return todos.get(id);
    }

    public static boolean takeTodo(int id, String newAssignee) {
        TodoItem todo = todos.get(id);
        if (todo != null) {
            todo.setAssignee(newAssignee);
            TodoManager.saveTodos();
            return true;
        }
        return false;
    }

    public static List<TodoItem> getAllTodos() {
        return new ArrayList<TodoItem>(todos.values());
    }

    public static List<TodoItem> getTodosByAssignee(String assignee) {
        return todos.values().stream().filter(todo -> todo.getAssignee().equalsIgnoreCase(assignee)).collect(Collectors.toList());
    }

    public static List<TodoItem> getUnassignedTodos() {
        return todos.values().stream().filter(TodoItem::isUnassigned).collect(Collectors.toList());
    }

    public static void clearAll() {
        todos.clear();
        TodoManager.saveTodos();
    }
}

